package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSwitzerland: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇭",
        description = "flag: Switzerland",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-switzerland", "switzerland-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Switzerland.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSwitzerland: Emoji get() = _FlagSwitzerland

/**
 * Alias to emoji [FlagSwitzerland] (Flags: country-flag: flag: Switzerland).
*/
public val Emoji.Companion.SwitzerlandFlag: Emoji get() = _FlagSwitzerland
