package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSyria: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇾",
        description = "flag: Syria",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-syria", "syria-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Syria.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSyria: Emoji get() = _FlagSyria

/**
 * Alias to emoji [FlagSyria] (Flags: country-flag: flag: Syria).
*/
public val Emoji.Companion.SyriaFlag: Emoji get() = _FlagSyria
