package org.kodein.emoji.food_drink.dishware

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllDishware() {
    add(intArrayOf(0x1f962), _Chopsticks)
    add(intArrayOf(0x1f37d, 0xfe0f), _ForkAndKnifeWithPlate)
    add(intArrayOf(0x1f37d), _ForkAndKnifeWithPlate)
    add(intArrayOf(0x1f374), _ForkAndKnife)
    add(intArrayOf(0x1f944), _Spoon)
    add(intArrayOf(0x1f52a), _KitchenKnife)
    add(intArrayOf(0x1fad9), _Jar)
    add(intArrayOf(0x1f3fa), _Amphora)
}

internal suspend fun SequenceScope<Emoji>.yieldAllDishware() {
    yield(_Chopsticks)
    yield(_ForkAndKnifeWithPlate)
    yield(_ForkAndKnife)
    yield(_Spoon)
    yield(_KitchenKnife)
    yield(_Jar)
    yield(_Amphora)
}

internal val countDishware = 7

/**
 * All Emoji of the Food & Drink: dishware subgroup.
*/
public fun Emoji.Companion.sequenceDishware(): Sequence<Emoji> =
    sequence { yieldAllDishware() }

/**
 * All Emoji of the Food & Drink: dishware subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listDishware(): List<Emoji> =
    ArrayList<Emoji>(countDishware).also { list -> sequenceDishware().forEach { list.add(it) } }

@Deprecated("Renamed listDishware.", replaceWith = ReplaceWith("listDishware()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allDishware(): List<Emoji> =
    listDishware()
