package org.kodein.emoji.food_drink.drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PouringLiquid: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🫗",
        description = "pouring liquid",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("pouring-liquid", "pour"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Food & Drink: drink: pouring liquid.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PouringLiquid: Emoji get() = _PouringLiquid

/**
 * Alias to emoji [PouringLiquid] (Food & Drink: drink: pouring liquid).
*/
public val Emoji.Companion.Pour: Emoji get() = _PouringLiquid
