package org.kodein.emoji.food_drink.food_prepared

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ShallowPanOfFood: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥘",
        description = "shallow pan of food",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("shallow-pan-of-food", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Food & Drink: food-prepared: shallow pan of food.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ShallowPanOfFood: Emoji get() = _ShallowPanOfFood
