package org.kodein.emoji.objects.computer

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Keyboard: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⌨️",
        description = "keyboard",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("keyboard", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: computer: keyboard.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Keyboard: Emoji get() = _Keyboard
