package org.kodein.emoji.objects.science

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SatelliteAntenna: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📡",
        description = "satellite antenna",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("satellite-antenna", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: science: satellite antenna.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SatelliteAntenna: Emoji get() = _SatelliteAntenna
