package org.kodein.emoji.objects.writing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Pencil: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "✏️",
        description = "pencil",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("pencil", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: writing: pencil.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Pencil: Emoji get() = _Pencil
