package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone2Emoji
import org.kodein.emoji.SkinTone2EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _CoupleWithHeartWomanWoman: SkinTone2Emoji = SkinTone2EmojiImpl(
    details = Emoji.Details(
        string = "👩‍❤️‍👩",
        description = "couple with heart: woman, woman",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("couple-with-heart-woman-woman", "heart-with-woman-and-woman"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk21c = 2,
    sk22c = 8,
)

/**
 * Emoji People & Body: family: couple with heart: woman, woman.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CoupleWithHeartWomanWoman: SkinTone2Emoji get() = _CoupleWithHeartWomanWoman

/**
 * Alias to emoji [CoupleWithHeartWomanWoman] (People & Body: family: couple with heart: woman, woman).
*/
public val Emoji.Companion.HeartWithWomanAndWoman: SkinTone2Emoji get() = _CoupleWithHeartWomanWoman
