package org.kodein.emoji.people_body.hands

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _RaisingHands: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🙌",
        description = "raising hands",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("raising-hands", "hooray"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hands: raising hands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RaisingHands: SkinTone1Emoji get() = _RaisingHands

/**
 * Alias to emoji [RaisingHands] (People & Body: hands: raising hands).
*/
public val Emoji.Companion.Hooray: SkinTone1Emoji get() = _RaisingHands
