package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPersonActivity() {
    add(intArrayOf(0x1f486), _PersonGettingMassage)
    addVariations(intArrayOf(0x1f486, 0x0), _PersonGettingMassage, 1)
    add(intArrayOf(0x1f486, 0x200d, 0x2642), _ManGettingMassage)
    addVariations(intArrayOf(0x1f486, 0x0, 0x200d, 0x2642), _ManGettingMassage, 1)
    add(intArrayOf(0x1f486, 0x200d, 0x2642, 0xfe0f), _ManGettingMassage)
    addVariations(intArrayOf(0x1f486, 0x0, 0x200d, 0x2642, 0xfe0f), _ManGettingMassage, 1)
    add(intArrayOf(0x1f486, 0x200d, 0x2640), _WomanGettingMassage)
    addVariations(intArrayOf(0x1f486, 0x0, 0x200d, 0x2640), _WomanGettingMassage, 1)
    add(intArrayOf(0x1f486, 0x200d, 0x2640, 0xfe0f), _WomanGettingMassage)
    addVariations(intArrayOf(0x1f486, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanGettingMassage, 1)
    add(intArrayOf(0x1f487), _PersonGettingHaircut)
    addVariations(intArrayOf(0x1f487, 0x0), _PersonGettingHaircut, 1)
    add(intArrayOf(0x1f487, 0x200d, 0x2642), _ManGettingHaircut)
    addVariations(intArrayOf(0x1f487, 0x0, 0x200d, 0x2642), _ManGettingHaircut, 1)
    add(intArrayOf(0x1f487, 0x200d, 0x2642, 0xfe0f), _ManGettingHaircut)
    addVariations(intArrayOf(0x1f487, 0x0, 0x200d, 0x2642, 0xfe0f), _ManGettingHaircut, 1)
    add(intArrayOf(0x1f487, 0x200d, 0x2640), _WomanGettingHaircut)
    addVariations(intArrayOf(0x1f487, 0x0, 0x200d, 0x2640), _WomanGettingHaircut, 1)
    add(intArrayOf(0x1f487, 0x200d, 0x2640, 0xfe0f), _WomanGettingHaircut)
    addVariations(intArrayOf(0x1f487, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanGettingHaircut, 1)
    add(intArrayOf(0x1f6b6), _PersonWalking)
    addVariations(intArrayOf(0x1f6b6, 0x0), _PersonWalking, 1)
    add(intArrayOf(0x1f6b6, 0x200d, 0x2642), _ManWalking)
    addVariations(intArrayOf(0x1f6b6, 0x0, 0x200d, 0x2642), _ManWalking, 1)
    add(intArrayOf(0x1f6b6, 0x200d, 0x2642, 0xfe0f), _ManWalking)
    addVariations(intArrayOf(0x1f6b6, 0x0, 0x200d, 0x2642, 0xfe0f), _ManWalking, 1)
    add(intArrayOf(0x1f6b6, 0x200d, 0x2640), _WomanWalking)
    addVariations(intArrayOf(0x1f6b6, 0x0, 0x200d, 0x2640), _WomanWalking, 1)
    add(intArrayOf(0x1f6b6, 0x200d, 0x2640, 0xfe0f), _WomanWalking)
    addVariations(intArrayOf(0x1f6b6, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanWalking, 1)
    add(intArrayOf(0x1f6b6, 0x200d, 0x27a1), _PersonWalkingFacingRight)
    addVariations(intArrayOf(0x1f6b6, 0x0, 0x200d, 0x27a1), _PersonWalkingFacingRight, 1)
    add(intArrayOf(0x1f6b6, 0x200d, 0x27a1, 0xfe0f), _PersonWalkingFacingRight)
    addVariations(intArrayOf(0x1f6b6, 0x0, 0x200d, 0x27a1, 0xfe0f), _PersonWalkingFacingRight, 1)
    add(intArrayOf(0x1f6b6, 0x200d, 0x2640, 0x200d, 0x27a1, 0xfe0f), _WomanWalkingFacingRight)
    addVariations(intArrayOf(0x1f6b6, 0x0, 0x200d, 0x2640, 0x200d, 0x27a1, 0xfe0f), _WomanWalkingFacingRight, 1)
    add(intArrayOf(0x1f6b6, 0x200d, 0x2640, 0xfe0f, 0x200d, 0x27a1, 0xfe0f), _WomanWalkingFacingRight)
    addVariations(intArrayOf(0x1f6b6, 0x0, 0x200d, 0x2640, 0xfe0f, 0x200d, 0x27a1, 0xfe0f), _WomanWalkingFacingRight, 1)
    add(intArrayOf(0x1f6b6, 0x200d, 0x2640, 0xfe0f, 0x200d, 0x27a1), _WomanWalkingFacingRight)
    addVariations(intArrayOf(0x1f6b6, 0x0, 0x200d, 0x2640, 0xfe0f, 0x200d, 0x27a1), _WomanWalkingFacingRight, 1)
    add(intArrayOf(0x1f6b6, 0x200d, 0x2640, 0x200d, 0x27a1), _WomanWalkingFacingRight)
    addVariations(intArrayOf(0x1f6b6, 0x0, 0x200d, 0x2640, 0x200d, 0x27a1), _WomanWalkingFacingRight, 1)
    add(intArrayOf(0x1f6b6, 0x200d, 0x2642, 0x200d, 0x27a1, 0xfe0f), _ManWalkingFacingRight)
    addVariations(intArrayOf(0x1f6b6, 0x0, 0x200d, 0x2642, 0x200d, 0x27a1, 0xfe0f), _ManWalkingFacingRight, 1)
    add(intArrayOf(0x1f6b6, 0x200d, 0x2642, 0xfe0f, 0x200d, 0x27a1, 0xfe0f), _ManWalkingFacingRight)
    addVariations(intArrayOf(0x1f6b6, 0x0, 0x200d, 0x2642, 0xfe0f, 0x200d, 0x27a1, 0xfe0f), _ManWalkingFacingRight, 1)
    add(intArrayOf(0x1f6b6, 0x200d, 0x2642, 0xfe0f, 0x200d, 0x27a1), _ManWalkingFacingRight)
    addVariations(intArrayOf(0x1f6b6, 0x0, 0x200d, 0x2642, 0xfe0f, 0x200d, 0x27a1), _ManWalkingFacingRight, 1)
    add(intArrayOf(0x1f6b6, 0x200d, 0x2642, 0x200d, 0x27a1), _ManWalkingFacingRight)
    addVariations(intArrayOf(0x1f6b6, 0x0, 0x200d, 0x2642, 0x200d, 0x27a1), _ManWalkingFacingRight, 1)
    add(intArrayOf(0x1f9cd), _PersonStanding)
    addVariations(intArrayOf(0x1f9cd, 0x0), _PersonStanding, 1)
    add(intArrayOf(0x1f9cd, 0x200d, 0x2642), _ManStanding)
    addVariations(intArrayOf(0x1f9cd, 0x0, 0x200d, 0x2642), _ManStanding, 1)
    add(intArrayOf(0x1f9cd, 0x200d, 0x2642, 0xfe0f), _ManStanding)
    addVariations(intArrayOf(0x1f9cd, 0x0, 0x200d, 0x2642, 0xfe0f), _ManStanding, 1)
    add(intArrayOf(0x1f9cd, 0x200d, 0x2640), _WomanStanding)
    addVariations(intArrayOf(0x1f9cd, 0x0, 0x200d, 0x2640), _WomanStanding, 1)
    add(intArrayOf(0x1f9cd, 0x200d, 0x2640, 0xfe0f), _WomanStanding)
    addVariations(intArrayOf(0x1f9cd, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanStanding, 1)
    add(intArrayOf(0x1f9ce), _PersonKneeling)
    addVariations(intArrayOf(0x1f9ce, 0x0), _PersonKneeling, 1)
    add(intArrayOf(0x1f9ce, 0x200d, 0x2642), _ManKneeling)
    addVariations(intArrayOf(0x1f9ce, 0x0, 0x200d, 0x2642), _ManKneeling, 1)
    add(intArrayOf(0x1f9ce, 0x200d, 0x2642, 0xfe0f), _ManKneeling)
    addVariations(intArrayOf(0x1f9ce, 0x0, 0x200d, 0x2642, 0xfe0f), _ManKneeling, 1)
    add(intArrayOf(0x1f9ce, 0x200d, 0x2640), _WomanKneeling)
    addVariations(intArrayOf(0x1f9ce, 0x0, 0x200d, 0x2640), _WomanKneeling, 1)
    add(intArrayOf(0x1f9ce, 0x200d, 0x2640, 0xfe0f), _WomanKneeling)
    addVariations(intArrayOf(0x1f9ce, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanKneeling, 1)
    add(intArrayOf(0x1f9ce, 0x200d, 0x27a1), _PersonKneelingFacingRight)
    addVariations(intArrayOf(0x1f9ce, 0x0, 0x200d, 0x27a1), _PersonKneelingFacingRight, 1)
    add(intArrayOf(0x1f9ce, 0x200d, 0x27a1, 0xfe0f), _PersonKneelingFacingRight)
    addVariations(intArrayOf(0x1f9ce, 0x0, 0x200d, 0x27a1, 0xfe0f), _PersonKneelingFacingRight, 1)
    add(intArrayOf(0x1f9ce, 0x200d, 0x2640, 0x200d, 0x27a1, 0xfe0f), _WomanKneelingFacingRight)
    addVariations(intArrayOf(0x1f9ce, 0x0, 0x200d, 0x2640, 0x200d, 0x27a1, 0xfe0f), _WomanKneelingFacingRight, 1)
    add(intArrayOf(0x1f9ce, 0x200d, 0x2640, 0xfe0f, 0x200d, 0x27a1, 0xfe0f), _WomanKneelingFacingRight)
    addVariations(intArrayOf(0x1f9ce, 0x0, 0x200d, 0x2640, 0xfe0f, 0x200d, 0x27a1, 0xfe0f), _WomanKneelingFacingRight, 1)
    add(intArrayOf(0x1f9ce, 0x200d, 0x2640, 0xfe0f, 0x200d, 0x27a1), _WomanKneelingFacingRight)
    addVariations(intArrayOf(0x1f9ce, 0x0, 0x200d, 0x2640, 0xfe0f, 0x200d, 0x27a1), _WomanKneelingFacingRight, 1)
    add(intArrayOf(0x1f9ce, 0x200d, 0x2640, 0x200d, 0x27a1), _WomanKneelingFacingRight)
    addVariations(intArrayOf(0x1f9ce, 0x0, 0x200d, 0x2640, 0x200d, 0x27a1), _WomanKneelingFacingRight, 1)
    add(intArrayOf(0x1f9ce, 0x200d, 0x2642, 0x200d, 0x27a1, 0xfe0f), _ManKneelingFacingRight)
    addVariations(intArrayOf(0x1f9ce, 0x0, 0x200d, 0x2642, 0x200d, 0x27a1, 0xfe0f), _ManKneelingFacingRight, 1)
    add(intArrayOf(0x1f9ce, 0x200d, 0x2642, 0xfe0f, 0x200d, 0x27a1, 0xfe0f), _ManKneelingFacingRight)
    addVariations(intArrayOf(0x1f9ce, 0x0, 0x200d, 0x2642, 0xfe0f, 0x200d, 0x27a1, 0xfe0f), _ManKneelingFacingRight, 1)
    add(intArrayOf(0x1f9ce, 0x200d, 0x2642, 0xfe0f, 0x200d, 0x27a1), _ManKneelingFacingRight)
    addVariations(intArrayOf(0x1f9ce, 0x0, 0x200d, 0x2642, 0xfe0f, 0x200d, 0x27a1), _ManKneelingFacingRight, 1)
    add(intArrayOf(0x1f9ce, 0x200d, 0x2642, 0x200d, 0x27a1), _ManKneelingFacingRight)
    addVariations(intArrayOf(0x1f9ce, 0x0, 0x200d, 0x2642, 0x200d, 0x27a1), _ManKneelingFacingRight, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9af), _PersonWithWhiteCane)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f9af), _PersonWithWhiteCane, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9af, 0x200d, 0x27a1), _PersonWithWhiteCaneFacingRight)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f9af, 0x200d, 0x27a1), _PersonWithWhiteCaneFacingRight, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9af, 0x200d, 0x27a1, 0xfe0f), _PersonWithWhiteCaneFacingRight)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f9af, 0x200d, 0x27a1, 0xfe0f), _PersonWithWhiteCaneFacingRight, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f9af), _ManWithWhiteCane)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f9af), _ManWithWhiteCane, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f9af, 0x200d, 0x27a1), _ManWithWhiteCaneFacingRight)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f9af, 0x200d, 0x27a1), _ManWithWhiteCaneFacingRight, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f9af, 0x200d, 0x27a1, 0xfe0f), _ManWithWhiteCaneFacingRight)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f9af, 0x200d, 0x27a1, 0xfe0f), _ManWithWhiteCaneFacingRight, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f9af), _WomanWithWhiteCane)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f9af), _WomanWithWhiteCane, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f9af, 0x200d, 0x27a1), _WomanWithWhiteCaneFacingRight)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f9af, 0x200d, 0x27a1), _WomanWithWhiteCaneFacingRight, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f9af, 0x200d, 0x27a1, 0xfe0f), _WomanWithWhiteCaneFacingRight)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f9af, 0x200d, 0x27a1, 0xfe0f), _WomanWithWhiteCaneFacingRight, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9bc), _PersonInMotorizedWheelchair)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f9bc), _PersonInMotorizedWheelchair, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9bc, 0x200d, 0x27a1), _PersonInMotorizedWheelchairFacingRight)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f9bc, 0x200d, 0x27a1), _PersonInMotorizedWheelchairFacingRight, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9bc, 0x200d, 0x27a1, 0xfe0f), _PersonInMotorizedWheelchairFacingRight)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f9bc, 0x200d, 0x27a1, 0xfe0f), _PersonInMotorizedWheelchairFacingRight, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f9bc), _ManInMotorizedWheelchair)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f9bc), _ManInMotorizedWheelchair, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f9bc, 0x200d, 0x27a1), _ManInMotorizedWheelchairFacingRight)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f9bc, 0x200d, 0x27a1), _ManInMotorizedWheelchairFacingRight, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f9bc, 0x200d, 0x27a1, 0xfe0f), _ManInMotorizedWheelchairFacingRight)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f9bc, 0x200d, 0x27a1, 0xfe0f), _ManInMotorizedWheelchairFacingRight, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f9bc), _WomanInMotorizedWheelchair)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f9bc), _WomanInMotorizedWheelchair, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f9bc, 0x200d, 0x27a1), _WomanInMotorizedWheelchairFacingRight)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f9bc, 0x200d, 0x27a1), _WomanInMotorizedWheelchairFacingRight, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f9bc, 0x200d, 0x27a1, 0xfe0f), _WomanInMotorizedWheelchairFacingRight)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f9bc, 0x200d, 0x27a1, 0xfe0f), _WomanInMotorizedWheelchairFacingRight, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9bd), _PersonInManualWheelchair)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f9bd), _PersonInManualWheelchair, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9bd, 0x200d, 0x27a1), _PersonInManualWheelchairFacingRight)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f9bd, 0x200d, 0x27a1), _PersonInManualWheelchairFacingRight, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9bd, 0x200d, 0x27a1, 0xfe0f), _PersonInManualWheelchairFacingRight)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f9bd, 0x200d, 0x27a1, 0xfe0f), _PersonInManualWheelchairFacingRight, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f9bd), _ManInManualWheelchair)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f9bd), _ManInManualWheelchair, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f9bd, 0x200d, 0x27a1), _ManInManualWheelchairFacingRight)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f9bd, 0x200d, 0x27a1), _ManInManualWheelchairFacingRight, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f9bd, 0x200d, 0x27a1, 0xfe0f), _ManInManualWheelchairFacingRight)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f9bd, 0x200d, 0x27a1, 0xfe0f), _ManInManualWheelchairFacingRight, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f9bd), _WomanInManualWheelchair)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f9bd), _WomanInManualWheelchair, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f9bd, 0x200d, 0x27a1), _WomanInManualWheelchairFacingRight)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f9bd, 0x200d, 0x27a1), _WomanInManualWheelchairFacingRight, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f9bd, 0x200d, 0x27a1, 0xfe0f), _WomanInManualWheelchairFacingRight)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f9bd, 0x200d, 0x27a1, 0xfe0f), _WomanInManualWheelchairFacingRight, 1)
    add(intArrayOf(0x1f3c3), _PersonRunning)
    addVariations(intArrayOf(0x1f3c3, 0x0), _PersonRunning, 1)
    add(intArrayOf(0x1f3c3, 0x200d, 0x2642), _ManRunning)
    addVariations(intArrayOf(0x1f3c3, 0x0, 0x200d, 0x2642), _ManRunning, 1)
    add(intArrayOf(0x1f3c3, 0x200d, 0x2642, 0xfe0f), _ManRunning)
    addVariations(intArrayOf(0x1f3c3, 0x0, 0x200d, 0x2642, 0xfe0f), _ManRunning, 1)
    add(intArrayOf(0x1f3c3, 0x200d, 0x2640), _WomanRunning)
    addVariations(intArrayOf(0x1f3c3, 0x0, 0x200d, 0x2640), _WomanRunning, 1)
    add(intArrayOf(0x1f3c3, 0x200d, 0x2640, 0xfe0f), _WomanRunning)
    addVariations(intArrayOf(0x1f3c3, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanRunning, 1)
    add(intArrayOf(0x1f3c3, 0x200d, 0x27a1), _PersonRunningFacingRight)
    addVariations(intArrayOf(0x1f3c3, 0x0, 0x200d, 0x27a1), _PersonRunningFacingRight, 1)
    add(intArrayOf(0x1f3c3, 0x200d, 0x27a1, 0xfe0f), _PersonRunningFacingRight)
    addVariations(intArrayOf(0x1f3c3, 0x0, 0x200d, 0x27a1, 0xfe0f), _PersonRunningFacingRight, 1)
    add(intArrayOf(0x1f3c3, 0x200d, 0x2640, 0x200d, 0x27a1, 0xfe0f), _WomanRunningFacingRight)
    addVariations(intArrayOf(0x1f3c3, 0x0, 0x200d, 0x2640, 0x200d, 0x27a1, 0xfe0f), _WomanRunningFacingRight, 1)
    add(intArrayOf(0x1f3c3, 0x200d, 0x2640, 0xfe0f, 0x200d, 0x27a1, 0xfe0f), _WomanRunningFacingRight)
    addVariations(intArrayOf(0x1f3c3, 0x0, 0x200d, 0x2640, 0xfe0f, 0x200d, 0x27a1, 0xfe0f), _WomanRunningFacingRight, 1)
    add(intArrayOf(0x1f3c3, 0x200d, 0x2640, 0xfe0f, 0x200d, 0x27a1), _WomanRunningFacingRight)
    addVariations(intArrayOf(0x1f3c3, 0x0, 0x200d, 0x2640, 0xfe0f, 0x200d, 0x27a1), _WomanRunningFacingRight, 1)
    add(intArrayOf(0x1f3c3, 0x200d, 0x2640, 0x200d, 0x27a1), _WomanRunningFacingRight)
    addVariations(intArrayOf(0x1f3c3, 0x0, 0x200d, 0x2640, 0x200d, 0x27a1), _WomanRunningFacingRight, 1)
    add(intArrayOf(0x1f3c3, 0x200d, 0x2642, 0x200d, 0x27a1, 0xfe0f), _ManRunningFacingRight)
    addVariations(intArrayOf(0x1f3c3, 0x0, 0x200d, 0x2642, 0x200d, 0x27a1, 0xfe0f), _ManRunningFacingRight, 1)
    add(intArrayOf(0x1f3c3, 0x200d, 0x2642, 0xfe0f, 0x200d, 0x27a1, 0xfe0f), _ManRunningFacingRight)
    addVariations(intArrayOf(0x1f3c3, 0x0, 0x200d, 0x2642, 0xfe0f, 0x200d, 0x27a1, 0xfe0f), _ManRunningFacingRight, 1)
    add(intArrayOf(0x1f3c3, 0x200d, 0x2642, 0xfe0f, 0x200d, 0x27a1), _ManRunningFacingRight)
    addVariations(intArrayOf(0x1f3c3, 0x0, 0x200d, 0x2642, 0xfe0f, 0x200d, 0x27a1), _ManRunningFacingRight, 1)
    add(intArrayOf(0x1f3c3, 0x200d, 0x2642, 0x200d, 0x27a1), _ManRunningFacingRight)
    addVariations(intArrayOf(0x1f3c3, 0x0, 0x200d, 0x2642, 0x200d, 0x27a1), _ManRunningFacingRight, 1)
    add(intArrayOf(0x1f483), _WomanDancing)
    addVariations(intArrayOf(0x1f483, 0x0), _WomanDancing, 1)
    add(intArrayOf(0x1f57a), _ManDancing)
    addVariations(intArrayOf(0x1f57a, 0x0), _ManDancing, 1)
    add(intArrayOf(0x1f574, 0xfe0f), _PersonInSuitLevitating)
    add(intArrayOf(0x1f574), _PersonInSuitLevitating)
    addVariations(intArrayOf(0x1f574, 0x0), _PersonInSuitLevitating, 1)
    add(intArrayOf(0x1f46f), _PeopleWithBunnyEars)
    add(intArrayOf(0x1f46f, 0x200d, 0x2642), _MenWithBunnyEars)
    add(intArrayOf(0x1f46f, 0x200d, 0x2642, 0xfe0f), _MenWithBunnyEars)
    add(intArrayOf(0x1f46f, 0x200d, 0x2640), _WomenWithBunnyEars)
    add(intArrayOf(0x1f46f, 0x200d, 0x2640, 0xfe0f), _WomenWithBunnyEars)
    add(intArrayOf(0x1f9d6), _PersonInSteamyRoom)
    addVariations(intArrayOf(0x1f9d6, 0x0), _PersonInSteamyRoom, 1)
    add(intArrayOf(0x1f9d6, 0x200d, 0x2642), _ManInSteamyRoom)
    addVariations(intArrayOf(0x1f9d6, 0x0, 0x200d, 0x2642), _ManInSteamyRoom, 1)
    add(intArrayOf(0x1f9d6, 0x200d, 0x2642, 0xfe0f), _ManInSteamyRoom)
    addVariations(intArrayOf(0x1f9d6, 0x0, 0x200d, 0x2642, 0xfe0f), _ManInSteamyRoom, 1)
    add(intArrayOf(0x1f9d6, 0x200d, 0x2640), _WomanInSteamyRoom)
    addVariations(intArrayOf(0x1f9d6, 0x0, 0x200d, 0x2640), _WomanInSteamyRoom, 1)
    add(intArrayOf(0x1f9d6, 0x200d, 0x2640, 0xfe0f), _WomanInSteamyRoom)
    addVariations(intArrayOf(0x1f9d6, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanInSteamyRoom, 1)
    add(intArrayOf(0x1f9d7), _PersonClimbing)
    addVariations(intArrayOf(0x1f9d7, 0x0), _PersonClimbing, 1)
    add(intArrayOf(0x1f9d7, 0x200d, 0x2642), _ManClimbing)
    addVariations(intArrayOf(0x1f9d7, 0x0, 0x200d, 0x2642), _ManClimbing, 1)
    add(intArrayOf(0x1f9d7, 0x200d, 0x2642, 0xfe0f), _ManClimbing)
    addVariations(intArrayOf(0x1f9d7, 0x0, 0x200d, 0x2642, 0xfe0f), _ManClimbing, 1)
    add(intArrayOf(0x1f9d7, 0x200d, 0x2640), _WomanClimbing)
    addVariations(intArrayOf(0x1f9d7, 0x0, 0x200d, 0x2640), _WomanClimbing, 1)
    add(intArrayOf(0x1f9d7, 0x200d, 0x2640, 0xfe0f), _WomanClimbing)
    addVariations(intArrayOf(0x1f9d7, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanClimbing, 1)
}

internal suspend fun SequenceScope<Emoji>.yieldAllPersonActivity() {
    yield(_PersonGettingMassage)
    yield(_ManGettingMassage)
    yield(_WomanGettingMassage)
    yield(_PersonGettingHaircut)
    yield(_ManGettingHaircut)
    yield(_WomanGettingHaircut)
    yield(_PersonWalking)
    yield(_ManWalking)
    yield(_WomanWalking)
    yield(_PersonWalkingFacingRight)
    yield(_WomanWalkingFacingRight)
    yield(_ManWalkingFacingRight)
    yield(_PersonStanding)
    yield(_ManStanding)
    yield(_WomanStanding)
    yield(_PersonKneeling)
    yield(_ManKneeling)
    yield(_WomanKneeling)
    yield(_PersonKneelingFacingRight)
    yield(_WomanKneelingFacingRight)
    yield(_ManKneelingFacingRight)
    yield(_PersonWithWhiteCane)
    yield(_PersonWithWhiteCaneFacingRight)
    yield(_ManWithWhiteCane)
    yield(_ManWithWhiteCaneFacingRight)
    yield(_WomanWithWhiteCane)
    yield(_WomanWithWhiteCaneFacingRight)
    yield(_PersonInMotorizedWheelchair)
    yield(_PersonInMotorizedWheelchairFacingRight)
    yield(_ManInMotorizedWheelchair)
    yield(_ManInMotorizedWheelchairFacingRight)
    yield(_WomanInMotorizedWheelchair)
    yield(_WomanInMotorizedWheelchairFacingRight)
    yield(_PersonInManualWheelchair)
    yield(_PersonInManualWheelchairFacingRight)
    yield(_ManInManualWheelchair)
    yield(_ManInManualWheelchairFacingRight)
    yield(_WomanInManualWheelchair)
    yield(_WomanInManualWheelchairFacingRight)
    yield(_PersonRunning)
    yield(_ManRunning)
    yield(_WomanRunning)
    yield(_PersonRunningFacingRight)
    yield(_WomanRunningFacingRight)
    yield(_ManRunningFacingRight)
    yield(_WomanDancing)
    yield(_ManDancing)
    yield(_PersonInSuitLevitating)
    yield(_PeopleWithBunnyEars)
    yield(_MenWithBunnyEars)
    yield(_WomenWithBunnyEars)
    yield(_PersonInSteamyRoom)
    yield(_ManInSteamyRoom)
    yield(_WomanInSteamyRoom)
    yield(_PersonClimbing)
    yield(_ManClimbing)
    yield(_WomanClimbing)
}

internal val countPersonActivity = 57

/**
 * All Emoji of the People & Body: person-activity subgroup.
*/
public fun Emoji.Companion.sequencePersonActivity(): Sequence<Emoji> =
    sequence { yieldAllPersonActivity() }

/**
 * All Emoji of the People & Body: person-activity subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listPersonActivity(): List<Emoji> =
    ArrayList<Emoji>(countPersonActivity).also { list -> sequencePersonActivity().forEach { list.add(it) } }

@Deprecated("Renamed listPersonActivity.", replaceWith = ReplaceWith("listPersonActivity()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allPersonActivity(): List<Emoji> =
    listPersonActivity()
