package org.kodein.emoji.people_body.person_sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonPlayingWaterPolo: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🤽",
        description = "person playing water polo",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("person-playing-water-polo", "water-polo"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-sport: person playing water polo.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonPlayingWaterPolo: SkinTone1Emoji get() = _PersonPlayingWaterPolo

/**
 * Alias to emoji [PersonPlayingWaterPolo] (People & Body: person-sport: person playing water polo).
*/
public val Emoji.Companion.WaterPolo: SkinTone1Emoji get() = _PersonPlayingWaterPolo
