package org.kodein.emoji.smileys_emotion.face_affection

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SmilingFaceWithTear: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥲",
        description = "smiling face with tear",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("smiling-face-with-tear", "happy-cry"),
        emoticons = listOf(":,)"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-affection: smiling face with tear.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SmilingFaceWithTear: Emoji get() = _SmilingFaceWithTear

/**
 * Alias to emoji [SmilingFaceWithTear] (Smileys & Emotion: face-affection: smiling face with tear).
*/
public val Emoji.Companion.HappyCry: Emoji get() = _SmilingFaceWithTear
