package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _AstonishedFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😲",
        description = "astonished face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("astonished-face", "astonished"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: astonished face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.AstonishedFace: Emoji get() = _AstonishedFace

/**
 * Alias to emoji [AstonishedFace] (Smileys & Emotion: face-concerned: astonished face).
*/
public val Emoji.Companion.Astonished: Emoji get() = _AstonishedFace
