package org.kodein.emoji.smileys_emotion.face_glasses

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SmilingFaceWithSunglasses: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😎",
        description = "smiling face with sunglasses",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("smiling-face-with-sunglasses", "sunglasses-face"),
        emoticons = listOf("B-)"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-glasses: smiling face with sunglasses.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SmilingFaceWithSunglasses: Emoji get() = _SmilingFaceWithSunglasses

/**
 * Alias to emoji [SmilingFaceWithSunglasses] (Smileys & Emotion: face-glasses: smiling face with sunglasses).
*/
public val Emoji.Companion.SunglassesFace: Emoji get() = _SmilingFaceWithSunglasses
