package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HeartWithRibbon: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💝",
        description = "heart with ribbon",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("heart-with-ribbon", "gift-heart"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: heart with ribbon.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HeartWithRibbon: Emoji get() = _HeartWithRibbon

/**
 * Alias to emoji [HeartWithRibbon] (Smileys & Emotion: heart: heart with ribbon).
*/
public val Emoji.Companion.GiftHeart: Emoji get() = _HeartWithRibbon
