package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _AbButtonBloodType: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🆎",
        description = "AB button (blood type)",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("ab-button-blood-type-", "ab-button", "blood-type-ab"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: alphanum: AB button (blood type).
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.AbButtonBloodType: Emoji get() = _AbButtonBloodType

/**
 * Alias to emoji [AbButtonBloodType] (Symbols: alphanum: AB button (blood type)).
*/
public val Emoji.Companion.AbButton: Emoji get() = _AbButtonBloodType

/**
 * Alias to emoji [AbButtonBloodType] (Symbols: alphanum: AB button (blood type)).
*/
public val Emoji.Companion.BloodTypeAb: Emoji get() = _AbButtonBloodType
