package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SoonArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔜",
        description = "SOON arrow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("soon-arrow", "soon", "arrow-soon"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: arrow: SOON arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SoonArrow: Emoji get() = _SoonArrow

/**
 * Alias to emoji [SoonArrow] (Symbols: arrow: SOON arrow).
*/
public val Emoji.Companion.Soon: Emoji get() = _SoonArrow

/**
 * Alias to emoji [SoonArrow] (Symbols: arrow: SOON arrow).
*/
public val Emoji.Companion.ArrowSoon: Emoji get() = _SoonArrow
