package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BlackLargeSquare: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⬛",
        description = "black large square",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("black-large-square", "black-square"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: black large square.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BlackLargeSquare: Emoji get() = _BlackLargeSquare

/**
 * Alias to emoji [BlackLargeSquare] (Symbols: geometric: black large square).
*/
public val Emoji.Companion.BlackSquare: Emoji get() = _BlackLargeSquare
