package org.kodein.emoji.symbols.math

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Infinity: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♾️",
        description = "infinity",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("infinity", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: math: infinity.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Infinity: Emoji get() = _Infinity
