package org.kodein.emoji.symbols.warning

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Warning: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⚠️",
        description = "warning",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("warning", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: warning: warning.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Warning: Emoji get() = _Warning
