package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CloudWithSnow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌨️",
        description = "cloud with snow",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("cloud-with-snow", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: cloud with snow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CloudWithSnow: Emoji get() = _CloudWithSnow
