package org.kodein.emoji.travel_places.transport_air

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlyingSaucer: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🛸",
        description = "flying saucer",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("flying-saucer", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Travel & Places: transport-air: flying saucer.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlyingSaucer: Emoji get() = _FlyingSaucer
