package org.kodein.emoji.travel_places.transport_ground

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OncomingAutomobile: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚘",
        description = "oncoming automobile",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("oncoming-automobile", "automobile-front"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: transport-ground: oncoming automobile.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OncomingAutomobile: Emoji get() = _OncomingAutomobile

/**
 * Alias to emoji [OncomingAutomobile] (Travel & Places: transport-ground: oncoming automobile).
*/
public val Emoji.Companion.AutomobileFront: Emoji get() = _OncomingAutomobile
