package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagGuernsey: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇬",
        description = "flag: Guernsey",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-guernsey", "guernsey-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Guernsey.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagGuernsey: Emoji get() = _FlagGuernsey

/**
 * Alias to emoji [FlagGuernsey] (Flags: country-flag: flag: Guernsey).
*/
public val Emoji.Companion.GuernseyFlag: Emoji get() = _FlagGuernsey
