package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagGuineaBissau: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇼",
        description = "flag: Guinea-Bissau",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-guinea-bissau", "guinea-bissau-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Guinea-Bissau.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagGuineaBissau: Emoji get() = _FlagGuineaBissau

/**
 * Alias to emoji [FlagGuineaBissau] (Flags: country-flag: flag: Guinea-Bissau).
*/
public val Emoji.Companion.GuineaBissauFlag: Emoji get() = _FlagGuineaBissau
