package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagNigeria: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇳🇬",
        description = "flag: Nigeria",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-nigeria", "nigeria-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Nigeria.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagNigeria: Emoji get() = _FlagNigeria

/**
 * Alias to emoji [FlagNigeria] (Flags: country-flag: flag: Nigeria).
*/
public val Emoji.Companion.NigeriaFlag: Emoji get() = _FlagNigeria
