package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagWallisFutuna: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇼🇫",
        description = "flag: Wallis & Futuna",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-wallis-futuna", "wallis-futuna-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Wallis & Futuna.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagWallisFutuna: Emoji get() = _FlagWallisFutuna

/**
 * Alias to emoji [FlagWallisFutuna] (Flags: country-flag: flag: Wallis & Futuna).
*/
public val Emoji.Companion.WallisFutunaFlag: Emoji get() = _FlagWallisFutuna
