package org.kodein.emoji.food_drink.dishware

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ForkAndKnifeWithPlate: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🍽️",
        description = "fork and knife with plate",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("fork-and-knife-with-plate", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Food & Drink: dishware: fork and knife with plate.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ForkAndKnifeWithPlate: Emoji get() = _ForkAndKnifeWithPlate
