package org.kodein.emoji.food_drink.drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HotBeverage: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "☕",
        description = "hot beverage",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("hot-beverage", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Food & Drink: drink: hot beverage.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HotBeverage: Emoji get() = _HotBeverage
