package org.kodein.emoji.objects.mail

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OutboxTray: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📤",
        description = "outbox tray",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("outbox-tray", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: mail: outbox tray.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OutboxTray: Emoji get() = _OutboxTray
