package org.kodein.emoji.objects.sound

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SpeakerMediumVolume: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔉",
        description = "speaker medium volume",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("speaker-medium-volume", "medium-volume"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: sound: speaker medium volume.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SpeakerMediumVolume: Emoji get() = _SpeakerMediumVolume

/**
 * Alias to emoji [SpeakerMediumVolume] (Objects: sound: speaker medium volume).
*/
public val Emoji.Companion.MediumVolume: Emoji get() = _SpeakerMediumVolume
