package org.kodein.emoji.people_body.person_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SpeakingHead: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🗣️",
        description = "speaking head",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("speaking-head", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji People & Body: person-symbol: speaking head.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SpeakingHead: Emoji get() = _SpeakingHead
