package org.kodein.emoji.smileys_emotion.emotion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RightAngerBubble: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🗯️",
        description = "right anger bubble",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("right-anger-bubble", "anger-bubble"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: emotion: right anger bubble.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RightAngerBubble: Emoji get() = _RightAngerBubble

/**
 * Alias to emoji [RightAngerBubble] (Smileys & Emotion: emotion: right anger bubble).
*/
public val Emoji.Companion.AngerBubble: Emoji get() = _RightAngerBubble
