package org.kodein.emoji.smileys_emotion.face_sleepy

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceSleepy() {
    add(intArrayOf(0x1f60c), _RelievedFace)
    add(intArrayOf(0x1f614), _PensiveFace)
    add(intArrayOf(0x1f62a), _SleepyFace)
    add(intArrayOf(0x1f924), _DroolingFace)
    add(intArrayOf(0x1f634), _SleepingFace)
}

internal suspend fun SequenceScope<Emoji>.yieldAllFaceSleepy() {
    yield(_RelievedFace)
    yield(_PensiveFace)
    yield(_SleepyFace)
    yield(_DroolingFace)
    yield(_SleepingFace)
}

internal val countFaceSleepy = 5

/**
 * All Emoji of the Smileys & Emotion: face-sleepy subgroup.
*/
public fun Emoji.Companion.sequenceFaceSleepy(): Sequence<Emoji> =
    sequence { yieldAllFaceSleepy() }

/**
 * All Emoji of the Smileys & Emotion: face-sleepy subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listFaceSleepy(): List<Emoji> =
    ArrayList<Emoji>(countFaceSleepy).also { list -> sequenceFaceSleepy().forEach { list.add(it) } }

@Deprecated("Renamed listFaceSleepy.", replaceWith = ReplaceWith("listFaceSleepy()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allFaceSleepy(): List<Emoji> =
    listFaceSleepy()
