package org.kodein.emoji.smileys_emotion.face_smiling

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GrinningSquintingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😆",
        description = "grinning squinting face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("grinning-squinting-face", "laughing"),
        emoticons = listOf("X-D"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-smiling: grinning squinting face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GrinningSquintingFace: Emoji get() = _GrinningSquintingFace

/**
 * Alias to emoji [GrinningSquintingFace] (Smileys & Emotion: face-smiling: grinning squinting face).
*/
public val Emoji.Companion.Laughing: Emoji get() = _GrinningSquintingFace
