package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GrowingHeart: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💗",
        description = "growing heart",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("growing-heart", "heart-grow"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: growing heart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GrowingHeart: Emoji get() = _GrowingHeart

/**
 * Alias to emoji [GrowingHeart] (Smileys & Emotion: heart: growing heart).
*/
public val Emoji.Companion.HeartGrow: Emoji get() = _GrowingHeart
