package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RedHeart: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "❤️",
        description = "red heart",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("red-heart", ),
        emoticons = listOf("<3"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: red heart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RedHeart: Emoji get() = _RedHeart
