package org.kodein.emoji.travel_places.place_geographic

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPlaceGeographic() {
    add(intArrayOf(0x1f3d4, 0xfe0f), _SnowCappedMountain)
    add(intArrayOf(0x1f3d4), _SnowCappedMountain)
    add(intArrayOf(0x26f0, 0xfe0f), _Mountain)
    add(intArrayOf(0x26f0), _Mountain)
    add(intArrayOf(0x1f30b), _Volcano)
    add(intArrayOf(0x1f5fb), _MountFuji)
    add(intArrayOf(0x1f3d5, 0xfe0f), _Camping)
    add(intArrayOf(0x1f3d5), _Camping)
    add(intArrayOf(0x1f3d6, 0xfe0f), _BeachWithUmbrella)
    add(intArrayOf(0x1f3d6), _BeachWithUmbrella)
    add(intArrayOf(0x1f3dc, 0xfe0f), _Desert)
    add(intArrayOf(0x1f3dc), _Desert)
    add(intArrayOf(0x1f3dd, 0xfe0f), _DesertIsland)
    add(intArrayOf(0x1f3dd), _DesertIsland)
    add(intArrayOf(0x1f3de, 0xfe0f), _NationalPark)
    add(intArrayOf(0x1f3de), _NationalPark)
}

internal suspend fun SequenceScope<Emoji>.yieldAllPlaceGeographic() {
    yield(_SnowCappedMountain)
    yield(_Mountain)
    yield(_Volcano)
    yield(_MountFuji)
    yield(_Camping)
    yield(_BeachWithUmbrella)
    yield(_Desert)
    yield(_DesertIsland)
    yield(_NationalPark)
}

internal val countPlaceGeographic = 9

/**
 * All Emoji of the Travel & Places: place-geographic subgroup.
*/
public fun Emoji.Companion.sequencePlaceGeographic(): Sequence<Emoji> =
    sequence { yieldAllPlaceGeographic() }

/**
 * All Emoji of the Travel & Places: place-geographic subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listPlaceGeographic(): List<Emoji> =
    ArrayList<Emoji>(countPlaceGeographic).also { list -> sequencePlaceGeographic().forEach { list.add(it) } }

@Deprecated("Renamed listPlaceGeographic.", replaceWith = ReplaceWith("listPlaceGeographic()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allPlaceGeographic(): List<Emoji> =
    listPlaceGeographic()
