package org.kodein.emoji.travel_places.transport_ground

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BusStop: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚏",
        description = "bus stop",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("bus-stop", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: transport-ground: bus stop.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BusStop: Emoji get() = _BusStop
