package org.kodein.emoji.activities.award_medal

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SportsMedal: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🏅",
        description = "sports medal",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("sports-medal", "medal"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: award-medal: sports medal.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SportsMedal: Emoji get() = _SportsMedal

/**
 * Alias to emoji [SportsMedal] (Activities: award-medal: sports medal).
*/
public val Emoji.Companion.Medal: Emoji get() = _SportsMedal
