package org.kodein.emoji.animals_nature

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.animals_nature.animal_mammal.*
import org.kodein.emoji.animals_nature.animal_bird.*
import org.kodein.emoji.animals_nature.animal_amphibian.*
import org.kodein.emoji.animals_nature.animal_reptile.*
import org.kodein.emoji.animals_nature.animal_marine.*
import org.kodein.emoji.animals_nature.animal_bug.*
import org.kodein.emoji.animals_nature.plant_flower.*
import org.kodein.emoji.animals_nature.plant_other.*


internal fun EmojiFinder.addAllAnimalsNature() {
    addAllAnimalMammal()
    addAllAnimalBird()
    addAllAnimalAmphibian()
    addAllAnimalReptile()
    addAllAnimalMarine()
    addAllAnimalBug()
    addAllPlantFlower()
    addAllPlantOther()
}

internal suspend fun SequenceScope<Emoji>.yieldAllAnimalsNature() {
    yieldAllAnimalMammal()
    yieldAllAnimalBird()
    yieldAllAnimalAmphibian()
    yieldAllAnimalReptile()
    yieldAllAnimalMarine()
    yieldAllAnimalBug()
    yieldAllPlantFlower()
    yieldAllPlantOther()
}

internal val countAnimalsNature = 160

/**
 * All Emoji of the Animals & Nature group.
*/
public fun Emoji.Companion.sequenceAnimalsNature(): Sequence<Emoji> =
    sequence { yieldAllAnimalsNature() }

/**
 * All Emoji of the Animals & Nature group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allAnimalsNature(): List<Emoji> =
    ArrayList<Emoji>(countAnimalsNature).also { list -> sequenceAnimalsNature().forEach { list.add(it) } }

internal fun allAnimalsNatureSubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "animal_mammal" to { Emoji.listAnimalMammal() },
        "animal_bird" to { Emoji.listAnimalBird() },
        "animal_amphibian" to { Emoji.listAnimalAmphibian() },
        "animal_reptile" to { Emoji.listAnimalReptile() },
        "animal_marine" to { Emoji.listAnimalMarine() },
        "animal_bug" to { Emoji.listAnimalBug() },
        "plant_flower" to { Emoji.listPlantFlower() },
        "plant_other" to { Emoji.listPlantOther() },
    )
