package org.kodein.emoji.animals_nature.plant_other

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LeaflessTree: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪾",
        description = "leafless tree",
        unicodeVersion = UnicodeVersion(16, 0),
        aliases = listOf("leafless-tree", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Animals & Nature: plant-other: leafless tree.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LeaflessTree: Emoji get() = _LeaflessTree
