package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagAmericanSamoa: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇦🇸",
        description = "flag: American Samoa",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-american-samoa", "american-samoa-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: American Samoa.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagAmericanSamoa: Emoji get() = _FlagAmericanSamoa

/**
 * Alias to emoji [FlagAmericanSamoa] (Flags: country-flag: flag: American Samoa).
*/
public val Emoji.Companion.AmericanSamoaFlag: Emoji get() = _FlagAmericanSamoa
