package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCaymanIslands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇰🇾",
        description = "flag: Cayman Islands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-cayman-islands", "cayman-islands-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Cayman Islands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCaymanIslands: Emoji get() = _FlagCaymanIslands

/**
 * Alias to emoji [FlagCaymanIslands] (Flags: country-flag: flag: Cayman Islands).
*/
public val Emoji.Companion.CaymanIslandsFlag: Emoji get() = _FlagCaymanIslands
