package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCuracAo: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇼",
        description = "flag: Curaçao",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-curac-ao", "curac-ao-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Curaçao.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCuracAo: Emoji get() = _FlagCuracAo

/**
 * Alias to emoji [FlagCuracAo] (Flags: country-flag: flag: Curaçao).
*/
public val Emoji.Companion.CuracAoFlag: Emoji get() = _FlagCuracAo
