package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagEswatini: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇿",
        description = "flag: Eswatini",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-eswatini", "swaziland-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Eswatini.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagEswatini: Emoji get() = _FlagEswatini

/**
 * Alias to emoji [FlagEswatini] (Flags: country-flag: flag: Eswatini).
*/
public val Emoji.Companion.SwazilandFlag: Emoji get() = _FlagEswatini
