package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagIraq: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇮🇶",
        description = "flag: Iraq",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-iraq", "iraq-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Iraq.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagIraq: Emoji get() = _FlagIraq

/**
 * Alias to emoji [FlagIraq] (Flags: country-flag: flag: Iraq).
*/
public val Emoji.Companion.IraqFlag: Emoji get() = _FlagIraq
