package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagJapan: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇯🇵",
        description = "flag: Japan",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("flag-japan", "japan-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Japan.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagJapan: Emoji get() = _FlagJapan

/**
 * Alias to emoji [FlagJapan] (Flags: country-flag: flag: Japan).
*/
public val Emoji.Companion.JapanFlag: Emoji get() = _FlagJapan
