package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagLiberia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇱🇷",
        description = "flag: Liberia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-liberia", "liberia-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.9f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Liberia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagLiberia: Emoji get() = _FlagLiberia

/**
 * Alias to emoji [FlagLiberia] (Flags: country-flag: flag: Liberia).
*/
public val Emoji.Companion.LiberiaFlag: Emoji get() = _FlagLiberia
